/*
        ANIMATION A PARTIR DE SPRITES - BASE DE DESSIN ANIME :
        UN BONHOMME SUR PLACE
*/

#include <allegro.h>

#define ECRAN_X	800
#define ECRAN_Y	600
#define MODE    GFX_AUTODETECT_WINDOWED

#define ERREUR(msg) {\
   set_gfx_mode(GFX_TEXT,0,0,0,0);\
   allegro_message("erreur ligne %d, fichier %s: %s\n",__LINE__, __FILE__,msg);\
   allegro_exit();\
   exit(EXIT_FAILURE);\
}
#define NB_DESSINS   10

int charger_dessins		(BITMAP *tab[],PALETTE pal);
/********************************************************
********************************************************/
int main (){
    
BITMAP* DESSIN[NB_DESSINS];
BITMAP* page;
PALETTE pal;
int i, posx, posy;
int dessin_cmpt;

   allegro_init();
   install_keyboard();
   
   if (set_gfx_mode(MODE, ECRAN_X, ECRAN_Y, 0, 0) != 0)
	 ERREUR(allegro_error);

   page = create_bitmap(ECRAN_X, ECRAN_Y);
   if ( ! charger_dessins(DESSIN,pal)||!page)
	ERREUR(allegro_error);

   set_palette(pal);

   posx = (ECRAN_X/2)- (DESSIN[0]->w/2);
   posy = (ECRAN_Y/2)- (DESSIN[0]->h/2);
   dessin_cmpt = 0;

   do{
		clear_bitmap(page);
		draw_sprite(page, DESSIN[dessin_cmpt], posx, posy);	 
		dessin_cmpt = (++dessin_cmpt)%10;
		blit(page, screen, 0,0,0,0,ECRAN_X, ECRAN_Y);

   }while ( ! key[KEY_ESC] );

	
   for( i = 0; i<NB_DESSINS; i++)
	   destroy_bitmap(DESSIN[ i ] );

   destroy_bitmap(page);

   exit(EXIT_SUCCESS);
}
END_OF_MAIN();
/********************************************************
********************************************************/
int charger_dessins(BITMAP *tab[],PALETTE pal){
int i,res=1;
char buf[80];
	
	for(i=0; i<NB_DESSINS;i++){
	    sprintf(buf,".\\dessins\\bonh%d.bmp",i+1);
	    tab[i] = load_bitmap(buf, pal );
		if( ! tab[i] )
			res=0;
	}
	return res;
}
/********************************************************
RAPPEL LINKAGE lib static :
pour dev :
dans menu : Projet/otpions du projet/paramtres/diteur de liens , l, 
copier la liste suivante :
  -lalleg_s -lgdi32 -lwinmm -lole32 -ldxguid -ldinput -lddraw -ldsound
et dans la colonne "compilateur"  gauche de l'diteur de liens copier
  -DALLEGRO_STATICLINK
cliquer "OK"
********************************************************/
